/* Mobile menu */
(function () {
  const menuIcon = document.querySelector('.burger-menu'),
    menu = document.querySelector('.header__menu'),
    body = document.querySelector('body'),
    OPEN_MENU_CLASS = 'active',
    OVERFLOW__BODY = 'mobile';

  menuIcon.addEventListener('input', function () {
    menu.classList.toggle(OPEN_MENU_CLASS);
    body.classList.toggle(OVERFLOW__BODY);
  });
})();

/* Hover buttons */
(function () {
  if (document.querySelectorAll('.hover').length) {
    const ANIMATEDCLASSNAME = 'animated';
    const ELEMENTS = document.querySelectorAll('.hover');
    const ELEMENTS_SPAN = [];

    ELEMENTS.forEach((element, index) => {
      let addAnimation = false;
      // If The span element for this element does not exist in the array, add it.
      if (!ELEMENTS_SPAN[index]) ELEMENTS_SPAN[index] = element.querySelector('span');

      element.addEventListener('mouseover', (e) => {
        ELEMENTS_SPAN[index].style.left = e.pageX - element.offsetLeft + 'px';
        ELEMENTS_SPAN[index].style.top = e.pageY - element.offsetTop + 'px';

        // Add an animation-class to animate via CSS.
        if (addAnimation) element.classList.add(ANIMATEDCLASSNAME);
      });
      element.addEventListener('mouseout', (e) => {
        ELEMENTS_SPAN[index].style.left = e.pageX - element.offsetLeft + 'px';
        ELEMENTS_SPAN[index].style.top = e.pageY - element.offsetTop + 'px';
      });
    });
  }
})();
